/*
 # Version: 1.0
 # Auteur: Etienne Vautherin pour Développer pour l'iPhone et l'iPad
 # http://alltouches.com
 # Les instructions de ce fichier sont fournies à titre d'illustration et n'engagent en rien leur auteur
 */

#import "DetailViewController_Shared.h"
#import "RootViewController_Shared.h"


@interface DetailViewController_Shared ()
- (void)configureView;
@end



@implementation DetailViewController_Shared

@synthesize detailItem, detailView, detailDescriptionLabel;
@dynamic detailViewFrame;

#pragma mark -
#pragma mark View lifecycle

- (CGRect)detailViewFrame {
	CGSize frameSize = self.view.frame.size;
	return CGRectMake(0.0, 0.0, frameSize.width, frameSize.height);
}

- (void)viewDidLoad {
	[super viewDidLoad];
	[[NSBundle mainBundle] loadNibNamed:@"DetailView_Shared" owner:self options:nil];
	detailView.frame = self.detailViewFrame;
	[self.view addSubview:detailView];
	self.detailView = nil;
}


#pragma mark -
#pragma mark Managing the detail item

/*
 When setting the detail item, update the view and dismiss the popover controller if it's showing.
 */
- (void)setDetailItem:(id)newDetailItem {
    if (detailItem != newDetailItem) {
        [detailItem release];
        detailItem = [newDetailItem retain];
        
        // Update the view.
        [self configureView];
    }
}


- (void)configureView {
    // Update the user interface for the detail item.
    detailDescriptionLabel.text = [detailItem description];   
}


#pragma mark -
#pragma mark Rotation support

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    return YES;
}


#pragma mark -
#pragma mark Memory management

- (void)dealloc {
    [detailItem release];
    [detailDescriptionLabel release];
    [super dealloc];
}

@end
